clear
set mem 5m
set more off
set matsize 800
program drop _all
cd "C:\Documents and Settings\Andrew Leigh\Top Incomes\"

* rndlgn obs mean var
* glcurve mincomeav [w=males]
* gen temp=normden(mincomeav) [w=males]
* sumdist mincomeav [w=males]
* replace lnp=ln(cumpctf*males_total)

*************************** USING EXTERNAL TOTALS ******************************************************

program define ginis1
* From 1984 onwards, we added bands. But we don't have #s of males for those years, so we have to collapse them again.
if year>=1984 {
sort band
gen temp_n=_n
tsset temp_n
gen temp1=1 if males==.
gen temp2=1 if males==.
replace temp2=1 if f.males==.
egen temp_persons=sum(persons) if temp2==1
replace persons=temp_persons if temp2==1
for any income taxable actual tax: egen temp_X=sum(pX) if temp2==1 \ replace pX=temp_X if temp2==1
drop if temp1==1
for any income tax: replace mX=pX*(males/persons) if temp2==1
drop temp*
}
 sort band
 gen n=_n
 gsort -n
 gen rn=_n
 tsset rn
 gen N=_N

* This next line is where we choose to use males 20+
 egen males_total=max(m_gt20)
* This next line assumes that the observed tax stats miss 5% of males, from across the distribution.
replace males_total=males_total*.95
 egen grossincome=sum(mincome)
 gen meanincome=(grossincome*1000000)/males_total
gen pctfreq=(males/males_total)*100
 gen cumpctfreq=pctfreq if rn==1
 replace cumpctfreq=pctfreq+l.cumpctfreq if rn>1
 gen totalincome=(mincome/grossincome)*100
 gen cumtotalincome=totalincome if rn==1
 replace cumtotalincome=totalincome+l.cumtotalincome if rn>1
gen lowerlim:"Lower limit relative to mean"=band/meanincome
gen cellmean=(totalincome/pctfreq)*meanincome
gen cellmeanrel:"Cell mean relative to mean"=cellmean/meanincome
tsset n
gen midptmean=(lowerlim+f.lowerlim)/2-cellmeanrel if n>1
gen alphacalc:"Alpha calc from F"=ln(cumpctfreq/f.cumpctfreq)/ln(f.lowerlim/lowerlim) if n>1
gen hupper=(cumpctfreq*2*(cellmeanrel-lowerlim)+f.cumpctfreq*(lowerlim+f.lowerlim-2*cellmeanrel))/(f.lowerlim-lowerlim) if n>1
gen hmeansplit=(cumpctfreq*(cellmeanrel-lowerlim)+f.cumpctfreq*(f.lowerlim-cellmeanrel))/(f.lowerlim-lowerlim) if n>1

* SHARES - USING THE CELL BOUNDS AND LINEAR EXTRAPOLATION
 for any 25 50 75 90 \ num 75 50 25 10 : gen earnX=band+((cumpctfreq-Y)/(cumpctfreq-f.cumpctfreq))*(f.band-band) if cumpctfreq>Y & f.cumpctfreq<=Y

* GINIS - IMPUTING ALL INCOME AT ZERO
egen taxablemales=sum(males)
sort cellmean
merge cellmean using mincome_dummy
drop if males==. & cellmean~=1
for any threshold males_total taxablemales year: egen temp=max(X) \ replace X=temp \ drop temp
replace males=males_total-taxablemales  if _merge==2 
replace mincome=1/1000000 if _merge==2 
sort cellmean
replace n=_n
 gsort -n
replace rn=_n
 tsset n
replace N=_N
 gen aggregateinc=mincome if n==1
drop grossincome
 egen grossincome=sum(mincome)
 replace aggregateinc=mincome+l.aggregateinc if n>1
gen temp=(aggregateinc/grossincome)*(males/males_total) if n==1
replace temp=((aggregateinc+l.aggregateinc)/grossincome)*(males/males_total) if n>1
egen sumtemp=sum(temp)
gen gini_max=(1-sumtemp)*N/(N-1)
drop temp sumtemp aggregateinc grossincome

 * GINI - IMPUTING INCOME USING THRESHOLD
 tsset n 
replace mincome=mincome+((threshold/1000000)*(males_total-taxablemales)) if _merge==2
egen grossincome=sum(mincome)
gen aggregateinc=mincome if n==1
 replace aggregateinc=mincome+l.aggregateinc if n>1
 gen temp=(aggregateinc/grossincome)*(males/males_total) if n==1
 replace temp=((aggregateinc+l.aggregateinc)/grossincome)*(males/males_total) if n>1
 egen sumtemp=sum(temp)
 gen gini_thresh=1-sumtemp*(N/(N-1))
 drop temp sumtemp aggregateinc grossincome

* GINI - FITTING A LOGNORMAL DISTRIBUTION
drop if _merge==2
drop _merge
replace cellmean=(mincome*1000000)/males
egen minimum_cellmean=min(cellmean)
sort cellmean
merge cellmean using mincome_dummy
drop _merge
for any threshold minimum_cellmean males_total taxablemales: egen temp=max(X) \ replace X=temp \ drop temp

drop if cellmean>threshold & males==.
gen lninc=ln(cellmean)
summarize lninc [fw=males], d
gen temp_mean=r(mean)
gen temp_sd=r(sd)
for any mean sd: egen lninc_X=max(temp_X) \ drop temp_X
summarize cellmean [fw=males], d
gen temp_mean=r(mean)
gen temp_sd=r(sd)
for any mean sd: egen inc_X=max(temp_X) \ drop temp_X
sum lninc* inc*

gen truncp=((males_total-taxablemales)/males_total)
gen invtrunc=invnorm(truncp)
gen lntrunc=ln(threshold)
gen dinvtrunc=normden(invtrunc)
gen mu=((lninc_mean*invtrunc)-lntrunc*(dinvtrunc/(1-truncp)))/(invtrunc-(dinvtrunc/(1-truncp)))
gen sigma=(lntrunc-mu)/invtrunc
for any mu sigma males_total: egen temp=max(X) \ replace X=temp \ drop temp
gen real_mean=exp(mu+((sigma^2)/2))
gen real_sd= (exp(2*(mu+sigma^2))-exp((2*mu)+(sigma^2)))^.5
gen pct=norm((lninc-mu)/(sigma^2))
*gen pct=(1/((2*_pi)^.5*sigma*cellmean))*exp(-.5*(((ln(cellmean-mu))/sigma)^2))
sort cellmean
gen temp1=_n
tsset temp1
gen temp2=pct
replace pct=pct-l.temp2 if l.temp2~=.
egen temp3=sum(pct) if males==.
replace pct=pct/temp3
gen imputedno=males_total-taxablemales
replace males=pct*imputedno if males==.

sort cellmean
replace n=_n
 gsort -n
replace rn=_n
 tsset n
replace N=_N
replace mincome=cellmean*males
egen grossincome=sum(mincome)
gen aggregateinc=mincome if n==1
 replace aggregateinc=mincome+l.aggregateinc if n>1
 gen temp=(aggregateinc/grossincome)*(males/males_total) if n==1
 replace temp=((aggregateinc+l.aggregateinc)/grossincome)*(males/males_total) if n>1
 egen sumtemp=sum(temp)
 gen gini_ln=1-sumtemp*(N/(N-1))
 drop temp sumtemp aggregateinc grossincome

* POST-TAX GINI (ASSUMING LOG-NORMALITY)
recode mtax .=0
replace mincome=mincome-(mtax*1000000)
sum mincome
egen grossincome=sum(mincome)
gen aggregateinc=mincome if n==1
 replace aggregateinc=mincome+l.aggregateinc if n>1
 gen temp=(aggregateinc/grossincome)*(males/males_total) if n==1
 replace temp=((aggregateinc+l.aggregateinc)/grossincome)*(males/males_total) if n>1
 egen sumtemp=sum(temp)
 gen gini_lnpt=1-sumtemp*(N/(N-1))
 drop temp sumtemp aggregateinc grossincome

* SUITS INDEX OF TAX PROGRESSIVITY
replace mincome=mincome+(mtax*1000000)
egen grosstax=sum(mtax)
gen aggregatetax=mtax if n==1
egen mincome_total=sum(mincome)
replace aggregatetax=mtax+l.aggregatetax if n>1
gen temp=(aggregatetax/grosstax)*(mincome/mincome_total) if n==1
replace temp=((aggregatetax+l.aggregatetax)/grosstax)*(mincome/mincome_total) if n>1
egen sumtemp=sum(temp)
gen suits_index=1-sumtemp

* COLLAPSING AND POSTING RESULTS
collapse (max) year (max) earn* (max) gini_max (max) gini_thresh (max) threshold (max) gini_ln (max) gini_lnpt (max) truncp (max) suits_index
gen ratio_7525=earn75/earn25 if earn25>threshold
replace ratio_7525=. if year==1947 | year>1990
gen ratio_9050=earn90/earn50
replace gini_thresh=. if gini_thresh==1
replace gini_max=. if gini_max==1
sum  year earn75 earn50 earn25 earn90 ratio_7525 ratio_9050 gini*
post _1 (year) (earn75) (earn50) (earn25) (earn90) (ratio_7525) (ratio_9050) (gini_max) (gini_thresh) (gini_ln) (gini_lnpt) (truncp) (suits_index)

end

************************USING CENSUS INCOME**************************************

program define ginis2
 sort band
 gen n=_n
 gen N=_N
 gsort -n
 gen rn=_n
gen males=males15 
if year==1980 | year==1995 | year==2000 {
replace males=males20
}
 egen males_total=sum(males)
tsset n
gen mincome=((band+f.band)/2)*males
replace mincome=band*1.15*males if rn==1
 tsset rn
 egen grossincome=sum(mincome)
 gen meanincome=grossincome/males_total
 gen pctfreq=(males/males_total)*100
 gen cumpctfreq=pctfreq if rn==1
 replace cumpctfreq=pctfreq+l.cumpctfreq if rn>1
 gen totalincome=(mincome/grossincome)*100
 gen cumtotalincome=totalincome if rn==1
 replace cumtotalincome=totalincome+l.cumtotalincome if rn>1
gen lowerlim:"Lower limit relative to mean"=band/meanincome
gen cellmean=(totalincome/pctfreq)*meanincome
gen cellmeanrel:"Cell mean relative to mean"=cellmean/meanincome
tsset n
gen midptmean=(lowerlim+f.lowerlim)/2-cellmeanrel if n>1
gen alphacalc:"Alpha calc from F"=ln(cumpctfreq/f.cumpctfreq)/ln(f.lowerlim/lowerlim) if n>1
gen hupper=(cumpctfreq*2*(cellmeanrel-lowerlim)+f.cumpctfreq*(lowerlim+f.lowerlim-2*cellmeanrel))/(f.lowerlim-lowerlim) if n>1
gen hmeansplit=(cumpctfreq*(cellmeanrel-lowerlim)+f.cumpctfreq*(f.lowerlim-cellmeanrel))/(f.lowerlim-lowerlim) if n>1

* SHARES - USING THE CELL BOUNDS AND LINEAR EXTRAPOLATION
 for any 25 50 75 90 \ num 75 50 25 10 : gen earnX_census=band+((cumpctfreq-Y)/(cumpctfreq-f.cumpctfreq))*(f.band-band) if cumpctfreq>Y & f.cumpctfreq<=Y

 * GINI - IMPUTING INCOME USING THRESHOLD
 tsset n 
gen aggregateinc=mincome if n==1
 replace aggregateinc=mincome+l.aggregateinc if n>1
 gen temp=(aggregateinc/grossincome)*(males/males_total) if n==1
 replace temp=((aggregateinc+l.aggregateinc)/grossincome)*(males/males_total) if n>1
 egen sumtemp=sum(temp)
 gen gini_census=1-sumtemp*(N/(N-1))
 drop temp sumtemp aggregateinc grossincome

* COLLAPSING AND POSTING RESULTS
collapse (max) year (max) earn* (max) gini_census
gen ratio_7525_census=earn75/earn25 
gen ratio_9050_census=earn90/earn50
post _2 (year) (earn75_census) (earn50_census) (earn25_census) (earn90_census) (ratio_7525_census) (ratio_9050_census)  (gini_census)

end

*********USING CENSUS IMPUTATION**********

program define ginis3
* From 1984 onwards, we added bands. But we don't have #s of males for those years, so we have to collapse them again.
if year>=1984 {
sort band
gen temp_n=_n
tsset temp_n
gen temp1=1 if males==.
gen temp2=1 if males==.
replace temp2=1 if f.males==.
egen temp_persons=sum(persons) if temp2==1
replace persons=temp_persons if temp2==1
for any income taxable actual tax: egen temp_X=sum(pX) if temp2==1 \ replace pX=temp_X if temp2==1
drop if temp1==1
for any income tax: replace mX=pX*(males/persons) if temp2==1
drop temp*
}
 sort band
 gen n=_n
 gen N=_N
 gsort -n
 gen rn=_n
 tsset rn
* Note that next line uses internal totals - we've already done imputation
 egen males_total=sum(males)
 egen grossincome=sum(mincome)
 gen meanincome=(grossincome*1000000)/males_total
 drop males_t
 gen pctfreq=(males/males_total)*100
 gen cumpctfreq=pctfreq if rn==1
 replace cumpctfreq=pctfreq+l.cumpctfreq if rn>1
 gen totalincome=(mincome/grossincome)*100
 gen cumtotalincome=totalincome if rn==1
 replace cumtotalincome=totalincome+l.cumtotalincome if rn>1
gen lowerlim:"Lower limit relative to mean"=band/meanincome
gen cellmean=(totalincome/pctfreq)*meanincome
gen cellmeanrel:"Cell mean relative to mean"=cellmean/meanincome
tsset n
gen midptmean=(lowerlim+f.lowerlim)/2-cellmeanrel if n>1
gen alphacalc:"Alpha calc from F"=ln(cumpctfreq/f.cumpctfreq)/ln(f.lowerlim/lowerlim) if n>1
gen hupper=(cumpctfreq*2*(cellmeanrel-lowerlim)+f.cumpctfreq*(lowerlim+f.lowerlim-2*cellmeanrel))/(f.lowerlim-lowerlim) if n>1
gen hmeansplit=(cumpctfreq*(cellmeanrel-lowerlim)+f.cumpctfreq*(f.lowerlim-cellmeanrel))/(f.lowerlim-lowerlim) if n>1

* SHARES - USING THE CELL BOUNDS AND LINEAR EXTRAPOLATION
 for any 25 50 75 90 \ num 75 50 25 10 : gen earnX=band+((cumpctfreq-Y)/(cumpctfreq-f.cumpctfreq))*(f.band-band) if cumpctfreq>Y & f.cumpctfreq<=Y

* GINIS - IMPUTING INCOME
 gen aggregateinc=mincome if n==1
 replace aggregateinc=mincome+l.aggregateinc if n>1
gen temp=(aggregateinc/grossincome)*(males/males_total) if n==1
replace temp=((aggregateinc+l.aggregateinc)/grossincome)*(males/males_total) if n>1
egen sumtemp=sum(temp)
gen gini_imp=(1-sumtemp)*(N/(N-1))
drop temp sumtemp aggregateinc

* POST-TAX GINI
recode mtax .=0
replace mincome=mincome-mtax
sum mincome
drop grossincome
egen grossincome=sum(mincome)
gen aggregateinc=mincome if n==1
 replace aggregateinc=mincome+l.aggregateinc if n>1
 gen temp=(aggregateinc/grossincome)*(males/males_total) if n==1
 replace temp=((aggregateinc+l.aggregateinc)/grossincome)*(males/males_total) if n>1
 egen sumtemp=sum(temp)
 gen gini_imp_pt=1-sumtemp*(N/(N-1))
 drop temp sumtemp aggregateinc grossincome

* SUITS INDEX OF TAX PROGRESSIVITY
replace mincome=mincome+mtax
egen grosstax=sum(mtax)
gen aggregatetax=mtax if n==1
egen mincome_total=sum(mincome)
replace aggregatetax=mtax+l.aggregatetax if n>1
gen temp=(aggregatetax/grosstax)*(mincome/mincome_total) if n==1
replace temp=((aggregatetax+l.aggregatetax)/grosstax)*(mincome/mincome_total) if n>1
egen sumtemp=sum(temp)
gen suits_index=1-sumtemp

* COLLAPSING AND POSTING RESULTS
collapse (max) year (max) earn*  (max) gini_imp (max) gini_imp_pt (max) suits_index (max) threshold
gen ratio_7525=earn75/earn25 if earn25>threshold
gen ratio_9050=earn90/earn50
post _3 (year) (gini_imp) (gini_imp_pt) (suits_index) (earn75) (earn50) (earn25) (earn90) (ratio_7525) (ratio_9050)

end

**********************************************************************************************



* GINIS1 - GINIS AT ZERO INCOME & THRESHOLD INCOME & ASSUMING LOGNORMALITY
cd "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\"
postfile _1 year earn75 earn50 earn25 earn90 ratio_7525 ratio_9050 gini_max gini_thresh gini_ln gini_lnpt truncp suits_index using ginis1.dta, replace
for num 1942/2000: cd "C:\Documents and Settings\Andrew Leigh\Top Incomes\Amended tax tables\" \ use population, clear \ sort year \ merge year using X \ drop if year~=X \ drop _merge \ cd "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\" \ ginis1
postclose _1

cd "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\"
postfile _2 year earn75_census earn50_census earn25_census earn90_census ratio_7525_census ratio_9050_census gini_census using ginis2.dta, replace
for num  1968 1973 1976 1981 1986 1996 2001 \ num 1968 1973 1975 1980 1985 1995 2000: use censusX.dta,clear \ gen year=Y \ ginis2
postclose _2

cd "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\"
use ginis2, clear
sort year
save, replace
use ginis1, clear
sort year
merge year using ginis2
drop _merge
gen ginis_lis=.
for num 81 85 89 94 \ num 0.281 0.292 0.304 0.311: replace ginis_lis=Y if year==19X
sort year
merge year using "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\ABS household ginis.dta"
drop _merge
la var gini_household "Household gini (ABS)"
la var gini_ln "Male gini (Taxation Statistics)"
*twoway scatter gini_household gini_ln, s([sourceyr]) ylabel(.4 .45) xlabel(.28 .37)
reg gini_ln gini_household, robust
save ginis_final, replace

cd "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\"
use fedineq_cps, clear
for any m f p: gen diffX=gini0_X-gini0_fam
sum diff*
for any m f p: reg gini0_fam gini0_X, robust
reg gini0_fam gini0_m gini0_f gini0_p, robust
for any m f p: reg diffX year, robust
*graph gini0_fam gini0_m, s([year])


***************************IMPUTING INCOME********************************************************8

program define quantiles
for Y in num 0/21: gen test_Y=awe_m*(Y/10)
end
for X in any 1968 1973 1975 1980 1985 1995 2000: cd "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\AWE\" \ use awe_m, clear \ keep if year==X \ quantiles \ drop awe_m year \ xpose, clear \ ren v1 quantiles \ replace quantiles=ln(quantiles) \ sort quantiles \ gen year=X \ save X, replace

for X in any 1968 1973 1976 1981 1986 1996 2001 \ Z in any 1968 1973 1975 1980 1985 1995 2000: cd "C:\Documents and Settings\Andrew Leigh\Top Incomes\Amended tax tables\" \ use Z, clear \ merge using "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\AWE\Z.dta" \ gen mminc=ln((mincome/males)*1000000) \ kdensity mminc [fw=males], gen(d_tax x_tax) width(.37) gauss at(quantiles) \ egen var_t=sum(x_tax) \ replace x_tax=x_tax/var_t \ egen malestot_tax=sum(males) \ gen males_tax=malestot_tax*x_tax \ keep malestot_tax males_tax x_tax d_tax quantiles \ merge using "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\censusX.dta" \ drop _merge \ gsort -band \ gen rn=_n \ tsset rn \ gen mminc=ln(band*1.15) if rn==1 \ replace mminc=ln((band+l.band)/2) if rn>1 \ rename males15 males \ sort band \ kdensity mminc [fw=males], gen(d_census x_census) width(.37) gauss at(quantiles) \ egen var_t=sum(x_census) \ replace x_census=x_census/var_t \ egen malestot_census=sum(males) \ gen males_census=malestot_census*x_census \ gen imputation=(males_census-males_tax)/(malestot_census-malestot_tax) \ replace quantiles=exp(quantiles) \ keep quantiles imputation males_census males_tax malestot_census \ save "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\Imputed\imputationZ.dta", replace

cd "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\Imputed\"
for any 1968 1973 1975 1980 1985 1995 2000: use imputationX, clear \ drop if imputation==. \ save imputationX, replace
for any 1968 1973 1975 1980 1985 1995 2000: use "C:\Documents and Settings\Andrew Leigh\Top Incomes\Amended tax tables\quantiles", clear \ merge using imputationX \ keep imputation quantiles \ drop if imputation==. \ save imputationX, replace
for any 1968: ren imputation imputationX 
for any 1973 1975 1980 1985 1995 2000: merge using imputationX \ keep imputation* quantiles \ ren imputation imputationX 
gen imputation=(imputation1968+ imputation1973+imputation1975+imputation1980+imputation1985+imputation1995+imputation2000)/7
drop imputation19* imputation2000
save imputation1968_2000.dta, replace

program define flip
drop quantile
xpose, clear
for num 1/21 \ num 0/20: ren vX quantileY
end
for any 1968_2000 1968 1973 1975 1980 1985 1995 2000: use imputationX, clear \ flip \ save imputationX, replace

program define imp_egen
for num 0/20: egen qX=max(quantileX) \ drop quantileX \ ren qX quantileX
end

program define imputing1
for num 0/20: gen imputedincX=(X/10)*awe_m \ replace males=males+(males_t-males_tax)*quantileX if (imputedincX<band & n==1) | (imputedincX>band & imputedincX<f.band & n~=1) \ replace mincome=mincome+(males_t-males_tax)*quantileX*(imputedincX/1000000) if (imputedincX<band & n==1) | (imputedincX>band & imputedincX<f.band & n~=1) 
end

program define imputing2
for num 0/20: gen imputedincX=(X/10)*awe_m \ replace males=males+(males_t-males_tax)*quantileX if (imputedincX<band & n==1) | (imputedincX>band & imputedincX<f.band & n~=1)
end

* Imputing by using the nearest census
cd "C:\Documents and Settings\Andrew Leigh\Top Incomes\Amended tax tables\"
for num 1942/1970: use population, clear \ ren  m_gt20 males_t \ sort year \ merge year using "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\AWE\awe_m.dta" \ drop _merge \ sort year \ merge year using X \ drop if year~=X \ drop _merge \ sort band \ gen n=_n \ merge using "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\Imputed\imputation1968.dta" \ drop _merge \ imp_egen \ egen males_tax=sum(males) \ tsset n \ imputing1 \ drop imput* quant* \ save "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\Imputed\X.dta", replace
for X in num 1971/2001 \ Z in num 1973 1973 1973 1975 1975 1975 1975 1980 1980 1980 1980 1980 1980 1985 1985 1985 1985 1985 1985 1995 1995 1995 1995 1995 1995 1995 1995 2000 2000 2000 2000: use population, clear \ ren  m_gt20 males_t \ sort year \ merge year using "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\AWE\awe_m.dta" \ drop _merge \ sort year \ merge year using X \ drop if year~=X \ drop _merge \ sort band \ gen n=_n \ merge using "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\Imputed\imputationZ.dta" \ drop _merge \ imp_egen \ egen males_tax=sum(males) \ tsset n \ imputing1 \ drop imput* quant* \ save "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\Imputed\X.dta", replace

cd "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\"
postfile _3 year gini_imp gini_imp_pt suits_index earn75 earn50 earn25 earn90 ratio_7525 ratio_9050 using ginis3.dta, replace
for num 1942/2001: use "C:\Documents and Settings\Andrew Leigh\Australian inequality paper\Imputed\X.dta", clear \ drop n \ ginis3
postclose _3
